/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourGlass;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.client.IRenderTypeable;

public abstract class BNPane
extends IronBarsBlock
implements IRenderTypeable {
    private final boolean dropSelf;

    protected BNPane(Block block, boolean dropSelf) {
        super(FabricBlockSettings.copyOf((BlockBehaviour)block).strength(0.3f, 0.3f).m_60955_());
        this.dropSelf = dropSelf;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (this.dropSelf) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }
        return super.m_49635_(state, builder);
    }

    @Override
    public BNRenderLayer getRenderLayer() {
        return BNRenderLayer.TRANSLUCENT;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean m_6104_(BlockState state, BlockState neighbor, Direction facing) {
        if (neighbor.m_60734_() == this) {
            if (!facing.m_122434_().m_122479_()) {
                return false;
            }
            if (((Boolean)state.m_61143_((Property)f_52314_.get(facing))).booleanValue() && ((Boolean)neighbor.m_61143_((Property)f_52314_.get(facing.m_122424_()))).booleanValue()) {
                return true;
            }
        }
        return super.m_6104_(state, neighbor, facing);
    }

    public static BNPane from(Block source, boolean dropSelf) {
        return (BNPane)BehaviourHelper.from((Block)source, s -> new Wood((Block)s, dropSelf), s -> new Stone((Block)s, dropSelf), s -> new Metal((Block)s, dropSelf), s -> new Obsidian((Block)s, dropSelf), s -> new Glass((Block)s, dropSelf));
    }

    public static class Glass
    extends BNPane
    implements BehaviourGlass {
        public Glass(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }

    public static class Obsidian
    extends BNPane
    implements BehaviourObsidian {
        public Obsidian(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }

    public static class Metal
    extends BNPane
    implements BehaviourMetal {
        public Metal(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }

    public static class Stone
    extends BNPane
    implements BehaviourStone {
        public Stone(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }

    public static class Wood
    extends BNPane
    implements BehaviourWood {
        public Wood(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }
}

